package ${packageName}.app.service.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import ${packageName}.app.service.ProductService;
import ${packageName}.infra.dto.Product;
import ${packageName}.infra.mapper.ProductMapper;
import io.choerodon.core.exception.CommonException;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service
public class ProductServiceImpl implements ProductService {
    private ProductMapper productMapper;

    public ProductServiceImpl(ProductMapper productMapper) {
        this.productMapper = productMapper;
    }

    @Override
    public PageInfo<Product> select(Pageable pageable){
        return PageHelper.startPage(pageable.getPageNumber(), pageable.getPageSize()).doSelectPageInfo(()-> productMapper.selectAll());
    }

    @Override
    public Product create(Product product) {
        if (productMapper.insertSelective(product) != 1){
            throw new CommonException("error.product.create");
        }
        return productMapper.selectByPrimaryKey(product.getId());
    }

    @Override
    public Product update(Product product) {
        if (productMapper.updateByPrimaryKeySelective(product) != 1){
            throw new CommonException("error.product.update");
        }
        return productMapper.selectByPrimaryKey(product.getId());
    }

    @Override
    public Product delete(Integer id) {
        Product product = productMapper.selectByPrimaryKey(id);
        if (product == null){
            throw new CommonException("error.product.notFound");
        }
        if (productMapper.deleteByPrimaryKey(product) != 1){
            throw new CommonException("error.product.delete");
        }
        return product;
    }
}
